import numpy as np
import matplotlib.pyplot as plt

from utils import get_group_regret, merge_comm

feducb_regrets = np.load('~/plt/feducb/group_regret_list_10.npy')
feducb_group_regret_mean, feducb_group_regret_std = np.mean(feducb_regrets, axis=0), np.std(feducb_regrets, axis=0)

des_regrets = np.load('~/plt/des/regret_lists_new_1e6_50_1.npy')
des_group_regret_mean, des_group_regret_std = get_group_regret(des_regrets)


tomf_regrets = [np.load('~/plt/tomf/regret_list_hetero_1e6_50.npy'),
                np.load('~/plt/tomf/regret_list_hetero_1e6_50.npy')]
tomf_regrets = merge_comm(tomf_regrets)
tomf_group_regret_mean, tomf_group_regret_std = get_group_regret(tomf_regrets)

gossip_regret = np.load('~/plt/gossip/regret_lists.npy')
gossip_group_regret_mean, gossip_group_regret_std = get_group_regret(gossip_regret)


ducb_regrets = [np.load('~/plt/ducb/regret_lists_10.npy'),
               np.load('~/plt/ducb/regret_lists_20.npy'),
               np.load('~/plt/ducb/regret_lists_30.npy'),
               np.load('~/plt/ducb/regret_lists_40.npy'),
               np.load('~/plt/ducb/regret_lists_50.npy')]
ducb_regrets = merge_comm(ducb_regrets)
ducb_group_regret_mean, ducb_group_regret_std = get_group_regret(ducb_regrets)


plt.rcParams['font.family'] = 'serif'
plt.rcParams['font.size'] = 20
plt.rcParams['axes.labelweight'] = 'bold'
plt.figure(figsize=(10, 7))


plt.plot(feducb_group_regret_mean, linestyle='--', marker='^', color='blue', label='FedUCB',
         markersize=8, markerfacecolor='white', markeredgewidth=2, markevery=100000)
plt.fill_between(range(len(feducb_group_regret_mean)),
                 feducb_group_regret_mean - feducb_group_regret_std,
                 feducb_group_regret_mean + feducb_group_regret_std,
                 color='blue', alpha=0.08)

plt.plot(tomf_group_regret_mean, linestyle=':', marker='*', color='red', label='TOMF',
         markersize=12, markerfacecolor='white', markeredgewidth=2, markevery=100000)
plt.fill_between(range(len(tomf_group_regret_mean)),
                 tomf_group_regret_mean - tomf_group_regret_std,
                 tomf_group_regret_mean + tomf_group_regret_std,
                 color='red', alpha=0.08)

plt.plot(gossip_group_regret_mean, linestyle='-', marker='o', color='green', label='Gossip',
         markersize=8, markerfacecolor='white', markeredgewidth=2, markevery=100000)
plt.fill_between(range(len(gossip_group_regret_mean)),
                 gossip_group_regret_mean - gossip_group_regret_std,
                 gossip_group_regret_mean + gossip_group_regret_std,
                 color='green', alpha=0.08)

plt.plot(des_group_regret_mean, linestyle='-.', marker='D', color='purple', label='DES',
         markersize=8, markerfacecolor='white', markeredgewidth=2, markevery=100000)
plt.fill_between(range(len(des_group_regret_mean)), 
                 des_group_regret_mean - des_group_regret_std, 
                 des_group_regret_mean + des_group_regret_std, 
                 color='purple', alpha=0.08)


plt.plot(ducb_group_regret_mean, linestyle='--', marker='x', color='brown', label='Distributed-UCB', 
         markersize=10, markerfacecolor='white',  markeredgewidth=2, markevery=100000)
plt.fill_between(range(len(ducb_group_regret_mean)), 
                 ducb_group_regret_mean - ducb_group_regret_std , 
                 ducb_group_regret_mean + ducb_group_regret_std * 0.2, 
                 color='brown', alpha=0.08)

# print(des_group_regret_mean)
plt.xlabel('Time Slots')
plt.ylabel('Group Regret')
plt.yscale('log')
plt.ylim(10, int(1e6))
plt.tight_layout()
plt.grid(False)
plt.tight_layout()
plt.savefig('~/plt/Group_Regret.png', dpi=300)
# plt.show()
